<?php

Class Pushnotifications extends CI_Controller
{
	private static $API_ACCESS_KEY = 'AIzaSyD4E2D3IJ3ONbd96-qzIl4JgmjJMzHy1PY';

	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->helpers('url');
		$this->load->model('users'); 
	}

	public function getOTATemplateSettings() {
		$costCenterId   = '' ;
		$userId  	    = '' ;
		$haveData		=  true;
		if( $this->session->userdata('type') != 'superadmin' ) {

			if ( $this->session->userdata('costcenterID') != '' ) {
				$costCenterId = $this->session->userdata('costcenterID') ;
				$userId 	  = $this->session->userdata('user_id') ;
			} else {
				echo json_encode([ 'error' => 1, 'message' => 'No Cost Center Found.' ]);
				exit;
			}

		} else {
			$userId = 'superadmin' ;
		}
		$dataModel['costCenterId']  = $costCenterId;
		$dataModel['userId'] 		= $userId;
		$getOTATemplateSettings = $this->users->getOTATemplateSettings($dataModel) ;
		$templateId = $this->input->post('templateId') ;
		//debug($getOTATemplateSettings) ;
		if ( $getOTATemplateSettings ) {
			if ($templateId) {
				$idToCheck = $templateId ;
			} else {
				$idToCheck =  $getOTATemplateSettings[0]['id'] ;
			}
			$error = 0 ;
			$message = "Data Found" ;
			foreach ($getOTATemplateSettings as $data) {
				if( $this->session->userdata('type') == 'superadmin' ) { 
					$templateFor =  ( $data['cost_centre_name'] ? '(Assigned to '. $data['cost_centre_name'] .')' : '(Not Assigned)') ;
				} else {
					$templateFor = "" ;
				}
				$selectHTML .= '<option value="' . $data['id']  .'" ' . ( $data['id'] == $idToCheck ? 'selected' : '') . '>' . $data['device_settings_name'] . $templateFor . '</option>';

				if ( $data['id'] == $idToCheck ) {
					if ($data['fall_detect_senstivity'] == 1){
						$fall_detect_senstivity = '1 (Low)' ;
					} elseif($data['fall_detect_senstivity'] == 5) {
						$fall_detect_senstivity = '5 (High)' ;
					} else {
						$fall_detect_senstivity = $data['fall_detect_senstivity'] ;
					}

					if ($data['gps_pos_criteria'] == 1){
						$gps_pos_criteria = "Alarm Activation Only" ;
					} elseif($data['gps_pos_criteria'] == 2) {
						$gps_pos_criteria = "All Signals But No Timer" ;
					} else {
						$gps_pos_criteria = "All Signals And Timer" ;
					}

					$otaTemplateData .= '<tr><td>SIP Calling</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['sip_call'] == 0 ? 'OFF' : 'ON' )    .'</label></div></td></tr><tr><td>TRIGGER SOS</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['trigger_sos'] == 0 ? 'OFF' : 'ON' )    .'</label></div></td></tr><tr><td>Level</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['sos_press_level'] == 1 ? 'LOW' : 'High' )    .'</label></div></td></tr><tr><td>RIP ALARM</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['rip_alarm'] == 0 ? 'OFF' : 'ON' )    .'</label></div></td></tr><tr><td>FALL DETECT</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['fall_detect'] == 0 ? 'OFF' : 'ON' )    .'</label></div></td></tr><tr><td>Sensitivity</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . $fall_detect_senstivity    .'</label></div></td></tr><tr><td> Min Mandown Timer	</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' .  $data['min_man_down_timer_minutes'] .' Minutes '.$data['min_man_down_timer_seconds'] .' Seconds</label></div></td></tr><tr><td>Max Mandown Timer</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' .  $data['max_man_down_timer_minutes'] .' Minutes '.$data['max_man_down_timer_seconds'] .' Seconds</label></div></td></tr><tr><td>Min Amber Timer</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' .  $data['min_amber_timer_hours'] .' Hours '.$data['min_amber_timer_minutes'] .' Minutes</label></div></td></tr><tr><td>Max Amber Timer</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' .  $data['max_amber_timer_hours'] .' Hours '.$data['max_amber_timer_minutes'] .' Minutes</label></div></td></tr><tr><td>GPS Positioning Criteria</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' .  $gps_pos_criteria .'</label></div></td></tr><tr><td>GPS Frequency</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' .  $data['gps_update_frequ_minutes'] .' Minutes </label></div></td></tr><tr><td>ABILITY TO ACCESS  <br />AND CHANGE SETTINGS</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['settings'] == 0 ? 'Restricted' : 'Allowed' )    .'</label></div></td></tr><tr><td>SMS Signalling</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['sms'] == 0 ? 'OFF' : 'ON' )    .'</label></div></td></tr><tr><td>Fingerprint Lock</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['finger_print_lock'] == 0 ? 'OFF' : 'ON' )    .'</label></div></td></tr><tr><td>Calendar</td><td class="text-center"><div class="form-group"><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1">' . ( $data['calendar'] == 0 ? 'OFF' : 'ON' )    .'</label></div></td></tr>';
				}
			}
		} else {
			$selectHTML 	  = '<option value="">No Template Found</option>';
			$otaTemplateData  =  '<tr><td>No Data Found</td></tr>' ;
			$error = 0 ;
			$message = "No Data Found" ;
			$haveData		=  false;
		}
		echo json_encode(['error' => $error, 'message' => $message, 'selectHTML' => $selectHTML, 'otaTemplateData' => $otaTemplateData, 'id' => $idToCheck, 'haveData' => $haveData    ]) ;
	}

	/*
	 * Function to send the template settings to devices.
	*/
	public function getDataFromOperatorsTable_send_notifactions_android() {
		$numberArray	 = $this->input->post('numberArray') ;
		$mergeArrayResults = [];
		$checkError		   = 0;
		if($numberArray) {

				$templateId	 	 = $this->input->post('templateId') ;
				$getData		 = $this->users->getDataFromOperatorsTable($this->input->post('numberArray')) ;
				$getTemplateData = $this->users->getSingleTemplateData($templateId) ;


				if($getData) {
					$fcmDeviceToken 	= [] ;
					$errorToCheckToken 	= [] ;
					$errorToCheck 		= [] ;
					$counter 			= 0 ;
					$counterToken 		= 0 ;
					foreach($getData as $data) {
						if (isset($data['device_token']) && $data['device_token']) {
							$fcmDeviceToken[] 			      		      = $data['device_token'] ;
							$errorToCheckToken[$counterToken]['name']	  =   $data['loginname'] ;
							$errorToCheckToken[$counterToken]['number']	  =   $data['number'] ;
							$counterToken++;
						} else {
							$checkError		  							=   1;
							$errorToCheck[$counter]['name']	  		 	=   $data['loginname'] ;
							$errorToCheck[$counter]['number']	  	  	=   $data['number'] ;
							$errorToCheck[$counter]['errorMessage']	  	=   'Not Sent' ;
							$counter++ ;
						}

					}

					//$fcmDeviceToken = ['ddALj7YFOAU:APA91bGpmiHHPjemYrKTzfAOdmN62k68cvKmU2xFtUP-TBLo-qqoeYLnJjN_H5nrZetjPfWgk890BIPF_sIETuKQ_a_-zFtjLKxPgIxTYi4I3Omeg0oWpPLBO_oI_BqsUnywpcB3Ir--'] ;
					if( $fcmDeviceToken ) {
						$url 			= 'https://fcm.googleapis.com/fcm/send' ;
						$serverKey      = self::$API_ACCESS_KEY ;
						$data = [

							   //'sipCall' 					=> $getTemplateData[0]['sip_call'] ,
							   'triggerSos' 				=> $getTemplateData[0]['trigger_sos'],
							   'presslabel' 				=> $getTemplateData[0]['sos_press_level'],
							   'ripAlarm'   				=> $getTemplateData[0]['rip_alarm'],
							  // 'fallDetect'    				=> $getTemplateData[0]['fall_detect'],
							  // 'fallSenstivity'				=> $getTemplateData[0]['fall_detect_senstivity'],
							   'minmandowntimerminutes' 	=> $getTemplateData[0]['min_man_down_timer_minutes'],
							   'minmandowntimerseconds'		=> $getTemplateData[0]['min_man_down_timer_seconds'],
							   'maxmandowntimerminutes'		=> $getTemplateData[0]['max_man_down_timer_minutes'],
							   'maxmandowntimerseconds'		=> $getTemplateData[0]['max_man_down_timer_seconds'],
							   'minambertimerhours'			=> $getTemplateData[0]['min_amber_timer_hours'],
							   'minambertimerminutes'		=> $getTemplateData[0]['min_amber_timer_minutes'],
							   'maxambertimerhours'			=> $getTemplateData[0]['max_amber_timer_hours'],
							   'maxambertimerminutes'		=> $getTemplateData[0]['max_amber_timer_minutes'],
							   'gpsfrequencyupdate'			=> $getTemplateData[0]['gps_update_frequ_minutes'],
							   'settings'					=> $getTemplateData[0]['settings'],
							   'gpsposcriteria'				=> $getTemplateData[0]['gps_pos_criteria'],
							   'settingName'				=> $getTemplateData[0]['device_settings_name'],
							   'settingId'					=> $getTemplateData[0]['id'],
							   'sms'						=> $getTemplateData[0]['sms'],
							   'finger_print_lock'			=> $getTemplateData[0]['finger_print_lock'],
							   'calendar'					=> $getTemplateData[0]['calendar']
							] ;
						$message = array(
							'message' => 'This is a testing message',
							'title' => 'Configuration received.',
							'subtitle' => 'This is a subtitle. subtitle',
							'tickerText' => 'Ticker text here...Ticker text here...',
							'vibrate' => 1,
							'sound' => 1,
							'largeIcon' => 'large_icon',
							'smallIcon' => 'small_icon',
							'data' => json_encode($data)
						);

						$headers = array(
							'Authorization: key=' . $serverKey,
							'Content-Type: application/json'
						);

						$fields = array(
							'registration_ids' => $fcmDeviceToken,
							'data' => $message,
						);

						//$result =  $this->useCurl($url, $headers, json_encode($fields));
						$ch = curl_init();
						// Set the url, number of POST vars, POST data
						curl_setopt($ch, CURLOPT_URL, $url);
						curl_setopt($ch, CURLOPT_POST, true);
						curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

						// Disabling SSL Certificate support temporarly
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
						if ($fields) {
							curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
						}

						// Execute post
						$result = curl_exec($ch);
						if ($result === FALSE) {
						   // die('Curl failed: ' . curl_error($ch));
						   $errorAndroid = 'Curl failed: ' . curl_error($ch) ;
						   $error = 1 ;
						   $resultAndroid = '' ;
						} else {
							$resultArray = json_decode($result, true);

							if (isset($resultArray['results']) && $resultArray['results']) {
								$counterNew = 0 ;
								foreach($resultArray['results'] as $data) {

									if (isset($data['error'])) {
										$errorToCheckToken[$counterNew]['errorMessage'] = $data['error'] ;
										$checkError	=   1;
									} else{
										$errorToCheckToken[$counterNew]['errorMessage'] = 'Sent' ;
										$this->users->saveUserTemplateSettings($getTemplateData[0]['id'], $errorToCheckToken[$counterNew]['number']) ;
									}

									$counterNew++;
								}
							}
							$mergeArrayResults   = array_merge($errorToCheckToken, $errorToCheck) ;
							$resultAndroid = $result ;
							$error = 0 ;
							$errorAndroid = "";
						}

						// Close connection
						curl_close($ch);
					}else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "The selected device is not logged in or not using the latest version of the app and did not receive the settings.";
					}
				} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
				}
			} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
			}

		echo json_encode([ 'error' => $error, 'errorAndroid' => $errorAndroid, 'resultAndroid' => $resultAndroid, 'mergeArrayResults' => $mergeArrayResults, 'checkError' => $checkError ]) ;


	}

	/*
	 * Function to send the broadcast message.
	*/

	public function sendBroadcastingMessage() {
		//$numberArray	 = $this->input->post('numberArray') ;
		//$numberArray	 = $this->session->userdata('numberArrayBroadcastMessage') ;
		$numberArray	 = json_decode($this->input->post('selectedUserData')) ;
		
		if ( !$numberArray ) {
			echo json_encode([ 'error' => 1, 'errorAndroid' => 'Please select users.' ]) ;
			exit ;
		}
		$numberArrayNew  = [] ;

		$from 		     = $this->input->post('from') ;
		$mainMessage	 = $this->input->post('message') ;
		$title	 		 = $this->input->post('title') ;
		$uniqueId		 = time().'-'.mt_rand();

		$add_compose_message_details = $this->users->add_compose_message_details($from, $mainMessage, $title) ;

		if (!$add_compose_message_details) {
			echo json_encode([ 'error' => 1, 'errorAndroid' => 'Network error, please try again later.' ]) ;
			exit ;
		}

		$count = 0 ;
		$array = (array) $numberArray;

		foreach($numberArray as $key => $value) {
			$numberArrayNew[] = $value->phone ;
			$numberArray[$key]->unique_id  =  $uniqueId;
			$numberArray[$key]->main_user_id  =  $this->session->userdata('user_id');
			$numberArray[$key]->main_user_cost_center_id  =  $this->session->userdata('costcenterID');
			$numberArray[$key]->compose_message_id  =  $add_compose_message_details;
			$numberArray[$key]->sent_at  =  date("Y-m-d H:i:s");
			$count++;
		}

		$add_broadcast_message_user_details = $this->users->add_broadcast_message_user_details($numberArray) ;

		if (!$add_broadcast_message_user_details) {
			echo json_encode([ 'error' => 1, 'errorAndroid' => 'Network error, please try again later.' ]) ;
			exit ;
		}

		$mergeArrayResults = [];
		//debug($_POST, 1) ;
		$checkError		   = 0;
		if($numberArray) {

				$getData		 = $this->users->getDataFromOperatorsTable($numberArrayNew) ;

				if($getData) {
					$fcmDeviceToken 	= [] ;
					$errorToCheckToken 	= [] ;
					$errorToCheck 		= [] ;
					$counter 			= 0 ;
					$counterToken 		= 0 ;
					foreach($getData as $data) {
						if (isset($data['device_token']) && $data['device_token']) {
							$fcmDeviceToken[] 			      		      = $data['device_token'] ;
							$errorToCheckToken[$counterToken]['name']	  =   $data['loginname'] ;
							$errorToCheckToken[$counterToken]['number']	  =   $data['number'] ;
							$counterToken++;
						} else {
							$checkError		  							=   1;
							$errorToCheck[$counter]['name']	  		 	=   $data['loginname'] ;
							$errorToCheck[$counter]['number']	  	  	=   $data['number'] ;
							$errorToCheck[$counter]['errorMessage']	  	=   'Not Sent' ;
							$this->users->updateBroadcastmessage($data['number'], $uniqueId, 'User Logged Off');
							$counter++ ;
						}

					}

					//$fcmDeviceToken = ['ddALj7YFOAU:APA91bGpmiHHPjemYrKTzfAOdmN62k68cvKmU2xFtUP-TBLo-qqoeYLnJjN_H5nrZetjPfWgk890BIPF_sIETuKQ_a_-zFtjLKxPgIxTYi4I3Omeg0oWpPLBO_oI_BqsUnywpcB3Ir--'] ;
					if( $fcmDeviceToken ) {
						$url 			= 'https://fcm.googleapis.com/fcm/send' ;
						$serverKey      = self::$API_ACCESS_KEY ;
						$message = array(
							'message' => $mainMessage,
							'title' => $title,
							'subtitle' => 'This is a subtitle. subtitle',
							'tickerText' => 'Ticker text here...Ticker text here...',
							'vibrate' => 1,
							'sound' => 1,
							'largeIcon' => 'large_icon',
							'smallIcon' => 'small_icon',
							'from_compose_message'      =>$from,
							'currentModule' => 'broadcastmessage'
						);

						$headers = array(
							'Authorization: key=' . $serverKey,
							'Content-Type: application/json'
						);

						$fields = array(
							'registration_ids' => $fcmDeviceToken,
							'data' => $message,
						);

						//$result =  $this->useCurl($url, $headers, json_encode($fields));
						$ch = curl_init();
						// Set the url, number of POST vars, POST data
						curl_setopt($ch, CURLOPT_URL, $url);
						curl_setopt($ch, CURLOPT_POST, true);
						curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

						// Disabling SSL Certificate support temporarly
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
						if ($fields) {
							curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
						}

						// Execute post
						$result = curl_exec($ch);
						if ($result === FALSE) {
						   // die('Curl failed: ' . curl_error($ch));
						   $errorAndroid = 'Curl failed: ' . curl_error($ch) ;
						   $error = 1 ;
						   $resultAndroid = '' ;
						} else {
							$resultArray = json_decode($result, true);

							if (isset($resultArray['results']) && $resultArray['results']) {
								$counterNew = 0 ;
								foreach($resultArray['results'] as $data) {

									if (isset($data['error'])) {
										$errorToCheckToken[$counterNew]['errorMessage'] = $data['error'] ;
										$this->users->updateBroadcastmessage($errorToCheckToken[$counterNew]['number'], $uniqueId, $data['error']);
										$checkError	=   1;
									} else{
										$errorToCheckToken[$counterNew]['errorMessage'] = 'Sent' ;
										$this->users->updateBroadcastmessage($errorToCheckToken[$counterNew]['number'], $uniqueId, 'delivered');
									}

									$counterNew++;
								}
							}
							$mergeArrayResults   = array_merge($errorToCheckToken, $errorToCheck) ;
							$resultAndroid = $result ;
							$error = 0 ;
							$errorAndroid = "";
						}

						// Close connection
						curl_close($ch);
					}else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "The selected device is not logged in or not using the latest version of the app and did not receive the settings.";
					}
				} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
				}
			} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
			}

		echo json_encode([ 'error' => $error, 'errorAndroid' => $errorAndroid, 'resultAndroid' => $resultAndroid, 'mergeArrayResults' => $mergeArrayResults, 'checkError' => $checkError ]) ;

	}

	/*
	 * Function to send the notification to devices and get the devices configuration back in response.
	*/
	public function sendConfigurationFCM(){
		//NotRegistered, 	InvalidRegistration errors from FCM
		$numberArray	 = json_decode($this->input->post('numberArray')) ;
		$uniqueId	 	 = $this->input->post('uniqueId') ;
		//$explodeNumbers  = explode(',', $numberArray) ;
		$mergeArrayResults = [];
		$checkError		   = 0;
		if($numberArray) {

				$getData		 = $this->users->getDataFromOperatorsTable($numberArray) ;
				if($getData) {
					$fcmDeviceToken 	= [] ;
					$errorToCheckToken 	= [] ;
					$errorToCheck 		= [] ;
					$counter 			= 0 ;
					$counterToken 		= 0 ;
					foreach($getData as $data) {
						if (isset($data['device_token']) && $data['device_token']) {
							$fcmDeviceToken[] 			      		      = $data['device_token'] ;
							$errorToCheckToken[$counterToken]['name']	  =   $data['loginname'] ;
							$errorToCheckToken[$counterToken]['number']	  =   $data['number'] ;
							$counterToken++;
						} else {
							$checkError		  							=   1;
							$errorToCheck[$counter]['name']	  		 	=   $data['loginname'] ;
							$errorToCheck[$counter]['number']	  	  	=   $data['number'] ;
							$errorToCheck[$counter]['errorMessage']	  	=   'Logged Off' ;
							$this->users->updateFCMGetConfiguration($data['number'], $uniqueId, 'Logged Off');
							$counter++ ;
						}

					}

					//$fcmDeviceToken = ['ddALj7YFOAU:APA91bGpmiHHPjemYrKTzfAOdmN62k68cvKmU2xFtUP-TBLo-qqoeYLnJjN_H5nrZetjPfWgk890BIPF_sIETuKQ_a_-zFtjLKxPgIxTYi4I3Omeg0oWpPLBO_oI_BqsUnywpcB3Ir--'] ;
					if( $fcmDeviceToken ) {
						$url 			= 'https://fcm.googleapis.com/fcm/send' ;
						$serverKey      = self::$API_ACCESS_KEY ;
						$message = array(
							'title' 		=> 'getConfiguration',
							'uniqueId'		=>  $uniqueId,
							'priority' 		=> 'high'
						);

						$headers = array(
							'Authorization: key=' . $serverKey,
							'Content-Type: application/json'
						);

						$fields = array(
							'registration_ids' => $fcmDeviceToken,
							'data' => $message,
							'priority' =>  'high'
						);

						//$result =  $this->useCurl($url, $headers, json_encode($fields));
						$ch = curl_init();
						// Set the url, number of POST vars, POST data
						curl_setopt($ch, CURLOPT_URL, $url);
						curl_setopt($ch, CURLOPT_POST, true);
						curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

						// Disabling SSL Certificate support temporarly
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
						if ($fields) {
							curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
						}

						// Execute post
						$result = curl_exec($ch);
						if ($result === FALSE) {
						   // die('Curl failed: ' . curl_error($ch));
						   $errorAndroid = 'Curl failed: ' . curl_error($ch) ;
						   $error = 1 ;
						   $resultAndroid = '' ;
						} else {
							$resultArray = json_decode($result, true);
							if (isset($resultArray['results']) && $resultArray['results']) {
								$counterNew = 0 ;
								foreach($resultArray['results'] as $data) {

									if (isset($data['error'])) {
										$errorToCheckToken[$counterNew]['errorMessage'] = $data['error'] ;
										$this->users->updateFCMGetConfiguration($errorToCheckToken[$counterNew]['number'], $uniqueId, $data['error']);
										$checkError	=   1;
									} else{
										$errorToCheckToken[$counterNew]['errorMessage'] = 'Sent' ;
										$this->users->updateFCMGetConfiguration($errorToCheckToken[$counterNew]['number'], $uniqueId, 'Sent');
									}

									$counterNew++;
								}
							}
							$mergeArrayResults   = array_merge($errorToCheckToken, $errorToCheck) ;
							$resultAndroid = $result ;
							$error = 0 ;
							$errorAndroid = "";
							$this->session->set_userdata('getConfigUniqueId', $uniqueId);
						}

						// Close connection
						curl_close($ch);
					}else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "The selected device is not logged in or not using the latest version of the app and did not receive the settings.";
					}
				} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
				}
			} else {
							$resultAndroid = "";
							$error = 1 ;
							$errorAndroid = "No users found!!!";
			}

		echo json_encode([ 'error' => $error, 'errorAndroid' => $errorAndroid, 'resultAndroid' => $resultAndroid, 'mergeArrayResults' => $mergeArrayResults, 'checkError' => $checkError ]) ;


	}


	// Data to add uniqueid, name, phone, serial number, transmitter type once the first time get configuration is clicked

	public function addDataGetConfiguration() {
		$dataToInsert = json_decode($this->input->post('dataToInsert'));

		if ($dataToInsert) {

			if ( $this->users->addFirstDataToGetConfiguration($dataToInsert) ) {
				$error = 0;
			}else {
				$error = 1;
			}

		} else {
			$error = 1;
		}


		echo json_encode([ 'error' => $error ]) ;
	}
	
	// Data to add uniqueid, name, phone, serial number, transmitter type once the first time refresh is clicked

	public function addDataGetConfigurationOnRefresh() {
		$getConfigUniqueId = $this->input->post('getConfigUniqueId');
		$uniqueIdNew	   = time().'-'.mt_rand();
		$data			   = '' ;
		if ($getConfigUniqueId) {

			if ( $data = $this->users->addFirstDataToGetConfigurationOnRefresh($getConfigUniqueId, $uniqueIdNew) ) {
				$error = 0;
				//delete previous entries
				//$this->users->deletePreviousConfiguration($getConfigUniqueId) ;
			}else {
				$error = 1;
			}

		} else {
			$error = 1;
		}


		echo json_encode([ 'error' => $error, 'data' => $data, 'uniqueIdNew' =>  $uniqueIdNew]) ;
	}
	

	public function getAppSettingsResponse() { //use if you want to change data here

		  /*
	   //need to update number key
	   if ( ( isset($dataFromApp['unique_id']) && !empty('unique_id') ) &&  ( isset($dataFromApp['number']) && !empty('number') ) )	{

			   $data		 = [] ;

			   $data['triggerSos'] 	= ( isset($dataFromApp['trigger_sos']) ? ($dataFromApp['trigger_sos'] == 0 ? 'OFF' : 'ON')  : '');
			   $data['presslabel'] 	= ( isset($dataFromApp['trigger_level']) ? ($dataFromApp['trigger_level'] == 1? 'LOW' : 'HIGH')  : '');
			   $data['ripAlarm'] 	= ( isset($dataFromApp['rip_alarm']) ? ($dataFromApp['rip_alarm'] == 0 ? 'OFF' : 'ON')  : '');
			   $data['fallDetect'] 	= ( isset($dataFromApp['fall_detect']) ? ($dataFromApp['fall_detect'] == 0 ? 'OFF' : 'ON')  : '');
			   if (isset($dataFromApp['fall_detect_sensitivity']){
				   if($dataFromApp['fall_detect_sensitivity'] == 1){
						$data['fallSenstivity']  = '1 (Low)' ;
				   } elseif($dataFromApp['fall_detect_sensitivity'] == 5) {
						$data['fallSenstivity'] = '5 (High)' ;
				   } else {
						$data['fallSenstivity'] = $dataFromApp['fall_detect_sensitivity'] ;
				   }
			   } else {
				  $data['fallSenstivity'] = '' ;
			   }

			   $data['minmandowntimerminutes'] 	= ( isset($dataFromApp['minmandowntimerminutes']) ?  $dataFromApp['minmandowntimerminutes'] : '');
			   $data['minmandowntimerseconds'] 	= ( isset($dataFromApp['minmandowntimerseconds']) ?  $dataFromApp['minmandowntimerseconds'] : '');
			   $data['maxmandowntimerminutes'] 	= ( isset($dataFromApp['maxmandowntimerminutes']) ?  $dataFromApp['maxmandowntimerminutes'] : '');
			   $data['maxmandowntimerseconds'] 	= ( isset($dataFromApp['maxmandowntimerseconds']) ?  $dataFromApp['maxmandowntimerseconds'] : '');
			   $data['minambertimerhours'] 		= ( isset($dataFromApp['minambertimerhours']) ?  $dataFromApp['minambertimerhours'] : '');
			   $data['minambertimerminutes'] 	= ( isset($dataFromApp['minambertimerminutes']) ?  $dataFromApp['minambertimerminutes'] : '');
			   $data['maxambertimerhours'] 		= ( isset($dataFromApp['maxambertimerhours']) ?  $dataFromApp['maxambertimerhours'] : '');
			   $data['maxambertimerminutes'] 	= ( isset($dataFromApp['maxambertimerminutes']) ?  $dataFromApp['maxambertimerminutes'] : '');

			   if (isset($dataFromApp['gps_position_criteria']){

				   if ($dataFromApp['gps_position_criteria'] == 1){

						$data['gpsposcriteria']  = "Alarm Activation Only" ;

				   } elseif($dataFromApp['gps_position_criteria'] == 2) {

						$data['gpsposcriteria']  = "All Signals But No Timer" ;

				   } else {

						$data['gpsposcriteria']  = "All Signals And Timer" ;

				   }
			   } else {
						$data['gpsposcriteria']  = "" ;
			   }


			   $data['gpsfrequencyupdate'] 	= ( isset($dataFromApp['gps_frequency']) ?  $dataFromApp['gps_frequency'] : '');
			   $data['settings'] 		    = ( isset($dataFromApp['settings_access']) ? ($dataFromApp['settings_access'] == 0 ? 'RESTRICTED' : 'ALLOWED')  : '');
			   $data['settings_name'] 		= ( isset($dataFromApp['setting_name']) ?  $dataFromApp['setting_name'] : '');
			   $data['settings_id'] 		= ( isset($dataFromApp['setting_id']) ?  $dataFromApp['setting_id'] : '');


			   $data['calendar'] 	= ( isset($dataFromApp['calendar']) ? ($dataFromApp['calendar'] == 0 ? 'OFF' : 'ON')  : '');


			   if (isset($dataFromApp['finger_print_lock']){

				   if ($dataFromApp['finger_print_lock'] == 0){

						$data['finger_print_lock']  = "OFF" ;

				   } elseif($dataFromApp['finger_print_lock'] == 1) {

						$data['finger_print_lock']  = "ON" ;

				   } else {

						$data['finger_print_lock']  = "N/A" ;

				   }
			   } else {
						$data['finger_print_lock']  = "" ;
			   }



			   if ($dataFromApp['unique_id'], $dataFromApp['number'], $data ) {
					$error = 0;
					$message = "Data updated successfully.";
			   } else {
					$error = 1;
					$message = "Data not updated .";
			   }

	   } else {
			   $error = 1;
			   $message = "Number/Unique can not be empty";
	   }


	   debug($data, 1) ;
	   echo json_encode([ 'error' => $error, 'message' => $message ]) ;
	   */

	}

	public function getConfigurationFCM() {
		$getConfigUniqueId = trim($this->input->post('getConfigUniqueId'));
		$getConfiguration = $this->users->getConfigurationFCM($getConfigUniqueId) ;
		$error = 0;
		$message = "" ;
		echo json_encode([  'error' => $error, 'message' => $message, 'getConfiguration' => $getConfiguration ]) ;
	}


	public function getSingleConfiguration() {
		$id 					= $this->input->post('id')  ;
		$getSingleConfiguration = $this->users->getSingleConfiguration($id) ;
		$otaTemplateData   = "" ;
		$otherAppSettings  = "" ;
		$gps_lat		   = "" ;
		$gps_lng		   = "" ;
		$userName		   = "" ;

		$error = 0 ;

		if ($getSingleConfiguration) {
			foreach ($getSingleConfiguration as $data) {

					if ($data['settings_name']) {
						$settingName     = $data['settings_name'] ;
						$maxManDownTimer = $data['maxmandowntimerminutes'] .' Minutes '.$data['maxmandowntimerseconds'] .' Seconds' ;
						$maxAmberTimer 	 = $data['maxambertimerhours'] .' Hours '.$data['maxambertimerminutes'] .' Minutes'    ;
					} else {
						$settingName 	 = "Default" ;
						$maxManDownTimer = $data['maxmandowntimerminutes'] .' Minutes '.$data['maxmandowntimerseconds'] .' Seconds' ;
						$maxAmberTimer 	 = $data['maxambertimerhours'] .' Hours '.$data['maxambertimerminutes'] .' Minutes'    ;
					}

					if ($data['fallSenstivity']) {
						if ($data['fallSenstivity'] == 1){
							$fall_detect_senstivity = '1 (Low)' ;
						} elseif($data['fallSenstivity'] == 5) {
							$fall_detect_senstivity = '5 (High)' ;
						} else {
							$fall_detect_senstivity = $data['fallSenstivity'] ;
						}
					} else {
						  $fall_detect_senstivity = '-' ;
					}

					if ($data['gpsposcriteria']) {
						if ($data['gpsposcriteria'] == 1){
							$gps_pos_criteria = "Alarm Activation Only" ;
						} elseif($data['gpsposcriteria'] == 2) {
							$gps_pos_criteria = "All Signals But No Timer" ;
						} else {
							$gps_pos_criteria = "All Signals And Timer" ;
						}
					} else {
						$gps_pos_criteria = '-' ;
					}

					$otaTemplateData .= '<tr><td>SETTINGS NAME</td><td><div class="form-group">' . $settingName    .'</div></td></tr><tr><td>TRIGGER SOS</td><td><div class="form-group">' . ( $data['triggerSos'] == 0 ? 'OFF' : 'ON' )    .'</div></td></tr><tr><td>Level</td><td><div class="form-group">' . ( $data['presslabel'] == 1 ? 'LOW' : 'High' )    .'</div></td></tr><tr><td>RIP ALARM</td><td><div class="form-group">' . ( $data['ripAlarm'] == 0 ? 'OFF' : 'ON' )    .'</div></td></tr><tr><td> Min Mandown Timer	</td><td><div class="form-group">' .  $data['minmandowntimerminutes'] .' Minutes '.$data['minmandowntimerseconds'] .' Seconds</div></td></tr><tr><td>Max Mandown Timer</td><td><div class="form-group">' .  $maxManDownTimer .'</div></td></tr><tr><td>Min Amber Timer</td><td><div class="form-group">' .  $data['minambertimerhours'] .' Hours '.$data['minambertimerminutes'] .' Minutes</div></td></tr><tr><td>Max Amber Timer</td><td><div class="form-group">' .  $maxAmberTimer .'</div></td></tr><tr><td>GPS Positioning Criteria</td><td><div class="form-group">' .  $gps_pos_criteria .'</div></td></tr><tr><td>GPS Frequency</td><td><div class="form-group">' .  $data['gpsfrequencyupdate'] .' Minutes </div></td></tr><tr><td>ABILITY TO ACCESS  <br />AND CHANGE SETTINGS</td><td><div class="form-group">' . ( $data['settings'] == 0 ? 'Restricted' : 'Allowed' )    .'</div></td></tr>';


					if ($data['finger_print_lock'] == "0"){
						$finger_print_lock = "OFF" ;
					} elseif($data['finger_print_lock'] == "1") {
						$finger_print_lock = "ON" ;
					} else {
						$finger_print_lock = "-" ;
					}

					//$otherAppSettings .= '<tr><td>Calendar</td><td><div class="form-group">' . ( $data['calendar'] == 0 ? 'OFF' : 'ON' )   .'</div></td></tr><tr><td>Finger Print Lock</td><td><div class="form-group">' .  $finger_print_lock   .'</div></td></tr>' ;

					$otherAppSettings .= '<tr><td>Calendar</td><td><div class="form-group">' . ( $data['calendar'] == 0 ? 'OFF' : 'ON' ) .'</div></td></tr><tr><td>Finger Print Lock</td><td><div class="form-group">' . $finger_print_lock .'</div></td></tr><tr><td>SMS Signalling</td><td><div class="form-group">' . ( $data["sms"] == "0" ? "Off" : ( $data["sms"] == "1" ? "On" : "-") )  .'</div></td></tr><tr><td colspan="2"><span class="_midTDheader">Device Info</span></td></tr><tr><td>Device ID</td><td><div class="form-group">' . $data["device_id"] . ' </div></td></tr><tr><td>IMEI Number</td><td><div class="form-group">' . $data["imei_no"] . '</div></td><tr><td>Carrier</td><td><div class="form-group">' . $data["carrier"] . '</div></td></tr><tr><td>Model</td><td><div class="form-group">' . $data["model"] . '</div></td></tr><tr><td>Version</td><td><div class="form-group">' . $data["version"] . '</div></td></tr><tr><td>App  Version</td><td><div class="form-group">' . $data["app_version"] . '</div></td></tr><tr><td>App Name</td><td><div class="form-group">' . $data["app_name"] . '</div></td></tr>';


					$gps_lat		   =  $data['gps_lat']  ;
					$gps_lng		   =  $data['gps_lng']  ;
					$userName		   =  $data['name']  ;
				}
			} else {
				$error = 1;
			}

			echo json_encode([ 'error' => $error, 'otaTemplateData' => $otaTemplateData, 'otherAppSettings' => $otherAppSettings, 'gps_lat' => $gps_lat, 'gps_lng' => $gps_lng, 'userName' => $userName ]) ;
	}


	function getUserForOperatorTable() {
		die('Please be sure you want to import the users data.');

		$conexion = new PDO("informix:host=".$this->config->item('pdo_connect')['host'].";service=".$this->config->item('pdo_connect')['service'].";database=".$this->config->item('pdo_connect')['database'].";server=".$this->config->item('pdo_connect')['server'].";protocol=".$this->config->item('pdo_connect')['protocol'].";EnableScrollableCursors=".$this->config->item('pdo_connect')['EnableScrollableCursors'].";client_locale=".$this->config->item('pdo_connect')['client_locale'].";db_locale=".$this->config->item('pdo_connect')['db_locale'] ,$this->config->item('pdo_connect')['db_user'],$this->config->item('pdo_connect')['db_pass']);


				$sql    = "select contsite.phone, customer.name, customer.serialno, systrans.recid
		from customer, contsite, systrans
		where customer.serialno = contsite.serialno
		and customer.serialno = systrans.serialno
		and contsite.contid = 1
		and systrans.recid in (7, 40);";

		$query   = $conexion->prepare($sql);
		$query->execute();
		$queryResponse = $query->fetchAll(PDO::FETCH_ASSOC);
		$userData = $this->users->insertUserDataOperators($queryResponse);

		//debug($queryResponse, 1) ;
	}


}
